/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.IIndexFileContributor;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.RebuildIndexJob;
import com.aptana.index.core.filter.IIndexFilterParticipant;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexManager {
    private static final String CONTENT_TYPE_ID = "contentTypeId";
    private static final String CONTENT_TYPE_BINDING = "contentTypeBinding";
    private static final String FILE_INDEXING_PARTICIPANTS_ID = "fileIndexingParticipants";
    private static final String TAG_FILE_INDEXING_PARTICIPANT = "fileIndexingParticipant";
    private static final String ATTR_CLASS = "class";
    private static final String INDEX_FILTER_PARTICIPANTS_ID = "indexFilterParticipants";
    private static final String ELEMENT_FILTER = "filter";
    private static final String FILE_CONTRIBUTORS_ID = "fileContributors";
    private static final String ELEMENT_CONTRIBUTOR = "contributor";
    private Map<URI, Index> indexes = new HashMap<URI, Index>();
    private ArrayList<IIndexFileContributor> fileContributors;
    private ArrayList<IIndexFilterParticipant> filterParticipants;
    static final ISchedulingRule MUTEX_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    IndexManager() {
    }

    public synchronized Index getIndex(URI path) {
        Index index = this.indexes.get(path);
        if (index == null) {
            try {
                index = new Index(path, true);
                this.indexes.put(path, index);
            }
            catch (IOException e) {
                try {
                    index = new Index(path, false);
                    this.indexes.put(path, index);
                    new RebuildIndexJob(path).schedule();
                }
                catch (IOException e1) {
                    IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)"An error occurred while trying to access an index", (Throwable)e1);
                }
            }
        }
        return index;
    }

    public synchronized List<URI> getIndexPaths() {
        return new ArrayList<URI>(this.indexes.keySet());
    }

    public synchronized void removeIndex(URI path) {
        Index index = this.getIndex(path);
        if (index != null) {
            index.deleteIndexFile();
        }
        this.indexes.remove(path);
    }

    private Map<IConfigurationElement, Set<IContentType>> getFileIndexingParticipants() {
        final HashMap<IConfigurationElement, Set<IContentType>> map = new HashMap<IConfigurationElement, Set<IContentType>>();
        final IContentTypeManager manager = Platform.getContentTypeManager();
        EclipseUtil.processConfigurationElements((String)"com.aptana.index.core", (String)FILE_INDEXING_PARTICIPANTS_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                IConfigurationElement[] contentTypes;
                HashSet<IContentType> types = new HashSet<IContentType>();
                IConfigurationElement[] iConfigurationElementArray = contentTypes = element.getChildren(IndexManager.CONTENT_TYPE_BINDING);
                int n = contentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement contentTypeBinding = iConfigurationElementArray[n2];
                    String contentTypeId = contentTypeBinding.getAttribute(IndexManager.CONTENT_TYPE_ID);
                    IContentType type = manager.getContentType(contentTypeId);
                    types.add(type);
                    ++n2;
                }
                map.put(element, types);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{IndexManager.TAG_FILE_INDEXING_PARTICIPANT});
            }
        });
        return map;
    }

    public List<IFileStoreIndexingParticipant> getIndexParticipants(String filename) {
        Map<IConfigurationElement, Set<IContentType>> participantstoContentTypes = this.getFileIndexingParticipants();
        HashSet<IFileStoreIndexingParticipant> participants = new HashSet<IFileStoreIndexingParticipant>(participantstoContentTypes.size());
        for (Map.Entry<IConfigurationElement, Set<IContentType>> entry : participantstoContentTypes.entrySet()) {
            IFileStoreIndexingParticipant participant;
            if (!this.hasType(filename, entry.getValue()) || (participant = this.createParticipant(entry.getKey())) == null) continue;
            participants.add(participant);
        }
        ArrayList<IFileStoreIndexingParticipant> result = new ArrayList<IFileStoreIndexingParticipant>(participants);
        Collections.sort(result, new Comparator<IFileStoreIndexingParticipant>(){

            @Override
            public int compare(IFileStoreIndexingParticipant arg0, IFileStoreIndexingParticipant arg1) {
                return arg1.getPriority() - arg0.getPriority();
            }
        });
        return result;
    }

    private boolean hasType(String filename, Set<IContentType> types) {
        if (types == null || types.isEmpty()) {
            return false;
        }
        for (IContentType type : types) {
            if (type == null || !type.isAssociatedWith(filename)) continue;
            return true;
        }
        return false;
    }

    private IFileStoreIndexingParticipant createParticipant(IConfigurationElement key) {
        try {
            return (IFileStoreIndexingParticipant)key.createExecutableExtension(ATTR_CLASS);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public synchronized List<IIndexFileContributor> getFileContributors() {
        if (this.fileContributors == null) {
            this.fileContributors = new ArrayList();
            EclipseUtil.processConfigurationElements((String)"com.aptana.index.core", (String)FILE_CONTRIBUTORS_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    try {
                        IIndexFileContributor participant = (IIndexFileContributor)element.createExecutableExtension(IndexManager.ATTR_CLASS);
                        IndexManager.this.fileContributors.add(participant);
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                    }
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{IndexManager.ELEMENT_CONTRIBUTOR});
                }
            });
            this.fileContributors.trimToSize();
        }
        return this.fileContributors;
    }

    public synchronized List<IIndexFilterParticipant> getFilterParticipants() {
        if (this.filterParticipants == null) {
            this.filterParticipants = new ArrayList();
            EclipseUtil.processConfigurationElements((String)"com.aptana.index.core", (String)INDEX_FILTER_PARTICIPANTS_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    try {
                        IIndexFilterParticipant participant = (IIndexFilterParticipant)element.createExecutableExtension(IndexManager.ATTR_CLASS);
                        IndexManager.this.filterParticipants.add(participant);
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                    }
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{IndexManager.ELEMENT_FILTER});
                }
            });
            this.filterParticipants.trimToSize();
        }
        return this.filterParticipants;
    }

    public synchronized boolean resetIndex(URI path) {
        block3: {
            try {
                Index index = this.getIndex(path);
                if (index == null) break block3;
                index.reset();
                return true;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                return false;
            }
        }
        return this.recreateIndex(path) != null;
    }

    public synchronized Index recreateIndex(URI path) {
        try {
            Index index = this.getIndex(path);
            ReadWriteLock monitor = index == null ? null : index.monitor;
            index = new Index(path, false);
            this.indexes.put(path, index);
            index.monitor = monitor;
            return index;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "[" + StringUtil.join((String)", ", (Object[])new Object[]{this.indexes.values()}) + "]";
    }
}

